/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.hotspot.service.impl;

import com.tp_link.eap.domain.eap.Client;
import com.tp_link.eap.domain.global.OperationResult;
import com.tp_link.eap.domain.hotspot.LocalUser;
import com.tp_link.eap.domain.portal.AuthInfo;
import com.tp_link.eap.domain.portal.Guest;
import com.tp_link.eap.domain.portal.StatCurrentGuest;
import com.tp_link.eap.domain.ui.Grid;
import com.tp_link.eap.domain.ui.QueryData;
import com.tp_link.eap.domain.ui.QueryFilter;
import com.tp_link.eap.domain.ui.QueryPage;
import com.tp_link.eap.domain.ui.QuerySort;
import com.tp_link.eap.monitor.hotspot.repo.LocalUserRepository;
import com.tp_link.eap.monitor.hotspot.service.LocalUserServiceI;
import com.tp_link.eap.monitor.portal.service.b;
import com.tp_link.eap.monitor.portal.service.d;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.util.a.e;
import com.tp_link.eap.util.l;
import com.tp_link.eap.util.p.a;
import com.tp_link.eap.util.p.c;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Validator;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Component(value="localUserService")
public class LocalUserService
extends com.tp_link.eap.i.a.a<LocalUser>
implements LocalUserServiceI {
    private final Logger a = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private LocalUserRepository b;
    @Autowired
    private MongoTemplate c;
    @Autowired
    private b d;
    @Autowired
    private d e;
    @Autowired
    private com.tp_link.eap.monitor.portal.service.a f;
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.d g;
    @Autowired
    private Validator validator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse handleLocalUserAuth(AuthInfo info) {
        Object object;
        String string = info.getUsername();
        String string2 = info.getPassword();
        String string3 = info.getCid();
        string3 = string3.replace(':', '-').toUpperCase(Locale.ROOT);
        String string4 = com.tp_link.eap.d.b.e((String)info.getAp());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (!this.isUserNameExistsInSite(string, string4)) {
            return new OperationResponse(ResErrorCode.bU);
        }
        LocalUser localUser = this.b.findByUserNameAndSite(string, string4);
        Object object2 = object = com.tp_link.eap.b.b.a.e((String)localUser.getId());
        synchronized (object2) {
            List<Guest> list;
            OperationResponse operationResponse;
            Comparable<Date> comparable;
            if (!string2.equals(localUser.getPassword())) {
                return new OperationResponse(ResErrorCode.bV);
            }
            if (localUser.getExpirationTime() != null && !localUser.getExpirationTime().equals("")) {
                try {
                    comparable = simpleDateFormat.parse(localUser.getExpirationTime());
                    if (comparable.getTime() < new Date().getTime() - 86400000L) {
                        return new OperationResponse(ResErrorCode.bW);
                    }
                }
                catch (ParseException parseException) {
                    this.a.warn(parseException.toString(), (Throwable)parseException);
                }
            }
            if (!localUser.getStatus()) {
                return new OperationResponse(ResErrorCode.bX);
            }
            if (localUser.getMacType().equals(com.tp_link.eap.util.e.dV)) {
                if (localUser.getMacAddress().equals("")) {
                    localUser.setMacAddress(string3);
                } else if (!string3.equals(localUser.getMacAddress())) {
                    return new OperationResponse(ResErrorCode.bY);
                }
            } else if (localUser.getMacType().equals(com.tp_link.eap.util.e.dU) && !string3.equals(localUser.getMacAddress())) {
                return new OperationResponse(ResErrorCode.bY);
            }
            if (!localUser.getQuotaLeft()) {
                return new OperationResponse(ResErrorCode.bZ);
            }
            comparable = 9999999999L;
            try {
                operationResponse = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                list = operationResponse.parse(localUser.getExpirationTime() + " 23:59:59");
                comparable = ((Date)((Object)list)).getTime() / 1000L;
            }
            catch (ParseException parseException) {
                this.a.warn(parseException.toString(), (Throwable)parseException);
            }
            if (localUser.getUsed() < localUser.getMaximumUsers()) {
                this.a.debug("Local User multi use.");
                if (localUser.getMacType().equals(com.tp_link.eap.util.e.dT)) {
                    localUser.setUsed(Integer.valueOf(localUser.getUsed() + 1));
                }
                if (localUser.getUsed().equals(localUser.getMaximumUsers())) {
                    // empty if block
                }
                if (!(operationResponse = this.f.addAuthInfo(info, (Long)comparable)).success()) {
                    this.a.debug("updateGuestStat fail.");
                    return operationResponse;
                }
                this.b.save(localUser);
                return com.tp_link.eap.util.e.bd;
            }
            operationResponse = this.e.getCurrentGuestsByLocalUserId(localUser.getId());
            if (operationResponse != null && operationResponse.size() >= localUser.getMaximumUsers()) {
                return new OperationResponse(ResErrorCode.ca, "Reach the limit of users: " + string + ".", null);
            }
            list = this.d.getValidGuestsByLocalUserId(localUser.getId());
            if (list == null || list.size() < localUser.getMaximumUsers()) {
                OperationResponse operationResponse2 = this.f.addAuthInfo(info, (Long)comparable);
                if (!operationResponse2.success()) {
                    this.a.debug("updateGuestStat fail.");
                    return operationResponse2;
                }
                return com.tp_link.eap.util.e.bd;
            }
            Guest guest = this.a(list, (List<StatCurrentGuest>)operationResponse);
            this.a.debug("get useless guest: " + guest);
            if (guest == null) {
                this.a.debug("Local User Service: no guest can be kictout.");
                return new OperationResponse(ResErrorCode.ca, "Reach the limit of users: " + localUser.getMaximumUsers() + ".", null);
            }
            OperationResponse operationResponse3 = this.f.kickoutHotspotGuest(guest);
            this.a.debug("kick out hotspot guest: " + guest);
            if (!operationResponse3.success()) {
                return operationResponse3;
            }
            operationResponse = this.f.addAuthInfo(info, (Long)comparable);
            if (!operationResponse.success()) {
                this.a.debug("updateGuestStat fail.");
                return operationResponse;
            }
            return com.tp_link.eap.util.e.bd;
        }
    }

    private Guest a(List<Guest> list, List<StatCurrentGuest> list2) {
        if (list == null) {
            return null;
        }
        if (list2 == null) {
            return list.get(0);
        }
        for (Guest guest : list) {
            int n2 = 0;
            for (n2 = 0; n2 < list2.size() && !guest.getId().equals(list2.get(n2).getGuestid()); ++n2) {
            }
            if (n2 != list2.size()) continue;
            return guest;
        }
        return null;
    }

    @Override
    public OperationResult clearLocalUsers() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String string = simpleDateFormat.format(new Date());
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"used").gt((Object)0));
        query.addCriteria(Criteria.where((String)"expirationTime").lt((Object)string));
        List list = this.c.find(query, LocalUser.class);
        this.a.debug("clear users size:" + list.size());
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new OperationResult(true, "No users need to be clear.");
        }
        for (LocalUser localUser : list) {
            com.tp_link.eap.b.b.a.f((String)localUser.getId());
            this.b.delete(localUser);
        }
        return new OperationResult(true, String.format("Clear %s users totally.", list.size()));
    }

    @Override
    public List<LocalUser> getAll() {
        List list = com.tp_link.eap.util.a.a.a(this.b.findAll());
        if (null == list || list.isEmpty()) {
            return null;
        }
        return list;
    }

    @Override
    public List<LocalUser> getAllBySite(String site) {
        return this.b.findBySiteOrderByIdAsc(site);
    }

    @Override
    public LocalUser getUser(String id) {
        return (LocalUser)this.b.findOne((Serializable)((Object)id));
    }

    @Override
    public OperationResponse saveUser(LocalUser user) {
        if (user == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        String string = com.tp_link.eap.d.b.a();
        if (null == string) {
            return com.tp_link.eap.util.e.aZ;
        }
        if ((user.getId() == null || user.getId().equals("")) && this.b.count() >= 50000L) {
            return new OperationResponse(ResErrorCode.eg);
        }
        LocalUser localUser = this.b.findByUserNameAndSite(user.getUserName(), string);
        if (localUser != null && !localUser.getId().equals(user.getId())) {
            return new OperationResponse(ResErrorCode.eh, String.format("LocalUser with userName '%s' is already existed.", localUser.getName()), null);
        }
        if (user.getMacType().equals(com.tp_link.eap.util.e.dT)) {
            user.setMacAddress("");
        } else if (user.getMacType().equals(com.tp_link.eap.util.e.dV) && localUser != null) {
            if (localUser.getMacType().equals(user.getMacType())) {
                user.setMacAddress(localUser.getMacAddress());
            } else {
                user.setMacAddress("");
            }
        }
        user.setSite(string);
        com.tp_link.eap.d.b.g((String)string);
        this.b.save(user);
        LocalUser localUser2 = (LocalUser)this.b.findOne((Serializable)((Object)user.getId()));
        if (localUser2 == null) {
            return com.tp_link.eap.util.e.bg;
        }
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResponse delUser(String id) {
        if (id == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        com.tp_link.eap.d.b.g((String)com.tp_link.eap.d.b.a());
        this.b.delete((Serializable)((Object)id));
        LocalUser localUser = (LocalUser)this.b.findOne((Serializable)((Object)id));
        if (localUser == null) {
            return com.tp_link.eap.util.e.bd;
        }
        return com.tp_link.eap.util.e.bg;
    }

    @Override
    public boolean updateUser(LocalUser user) {
        LocalUser localUser = this.getUserByUserNameAndSite(user.getUserName(), user.getSite());
        if (localUser == null && this.b.count() >= 50000L) {
            return false;
        }
        this.b.save(user);
        return true;
    }

    @Override
    public OperationResponse changeStatus(String id) {
        if (id == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        LocalUser localUser = (LocalUser)this.b.findOne((Serializable)((Object)id));
        if (localUser == null) {
            return com.tp_link.eap.util.e.bg;
        }
        localUser.setStatus(!localUser.getStatus());
        this.b.save(localUser);
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResponse clearDynamicMac(String id) {
        if (id == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        LocalUser localUser = (LocalUser)this.b.findOne((Serializable)((Object)id));
        if (localUser == null) {
            return com.tp_link.eap.util.e.bg;
        }
        if (localUser.getMacType() == 2) {
            Client client = this.g.getClient(localUser.getMacAddress(), com.tp_link.eap.d.b.a());
            if (client != null) {
                this.f.unAuth(client.getId());
            }
            localUser.setMacAddress("");
            this.b.save(localUser);
            return com.tp_link.eap.util.e.bd;
        }
        return com.tp_link.eap.util.e.bg;
    }

    public List<LocalUser> getList(QueryPage queryPage) {
        List<LocalUser> list = this.getList(queryPage, null, null, null);
        if (null == list || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<LocalUser> getList(QueryPage queryPage, QuerySort querySort) {
        List<LocalUser> list = this.getList(queryPage, querySort, null, null);
        if (null == list || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<LocalUser> getList(QueryPage queryPage, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        List<LocalUser> list = this.getList(queryPage, null, filters, searchFilters);
        if (null == list || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<LocalUser> getList(QueryPage queryPage, QuerySort querySort, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        List<LocalUser> list = this.b.getByFilters(queryPage, querySort, filters, searchFilters);
        if (null == list || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public long count(List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.b.getByFilters(null, null, filters, searchFilters).size();
    }

    @Override
    public void deleteBySite() {
        List<LocalUser> list = this.b.findBySiteOrderByIdAsc(com.tp_link.eap.d.b.a());
        if (!CollectionUtils.isEmpty(list)) {
            this.b.delete(list);
        }
    }

    @Override
    public void insertAll(List<LocalUser> objects) {
        this.c.insertAll(objects);
    }

    @Override
    public LocalUser getUserByUserNameAndSite(String userName, String site) {
        if (userName == null) {
            return null;
        }
        return this.b.findByUserNameAndSite(userName, site);
    }

    @Override
    public boolean isUserNameExistsInSite(String userName, String site) {
        if (com.tp_link.eap.util.a.e.a((String)userName) || com.tp_link.eap.util.a.e.a((String)site)) {
            return false;
        }
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"userName").is((Object)userName));
        query.addCriteria(Criteria.where((String)"site").is((Object)site));
        return this.c.exists(query, LocalUser.class);
    }

    @Override
    public void deleteAll() {
        this.b.deleteAll();
    }

    @Override
    public long count() {
        return this.b.count();
    }

    @Override
    public OperationResponse getGridLocalUsers(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)JSONObject.toBean((JSONObject)jSONObject, QueryData.class);
        String string = queryData.getSortName();
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            queryData.setSortName("_id");
            queryData.setSortOrder("desc");
        } else {
            queryData.setSortName(string + ",_id");
        }
        Grid grid = new Grid(queryData);
        grid.initSearch(queryData.getSearchKey(), new String[]{"userName", "name", "telephone"});
        long l2 = this.count(grid);
        grid.setTotalRows(l2);
        List list = this.getList(grid);
        if (null == list || list.isEmpty()) {
            return new OperationResponse(ResErrorCode.a, (Object)grid);
        }
        queryData.setSortName(string);
        grid.setData(list);
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    @Override
    public OperationResponse saveLocalUser(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        LocalUser localUser = (LocalUser)JSONObject.toBean((JSONObject)jSONObject, LocalUser.class);
        if (null == localUser) {
            return com.tp_link.eap.util.e.aZ;
        }
        OperationResponse operationResponse = com.tp_link.eap.util.p.a.a((Validator)this.validator, (Object)localUser);
        if (!operationResponse.success()) {
            return operationResponse;
        }
        localUser.setMacAddress(l.c((String)localUser.getMacAddress()));
        LocalUser localUser2 = null;
        if (localUser.getId() == null || localUser.getId().equals("")) {
            if (localUser.getDownloadLimit() == null) {
                localUser.setDownloadLimit(Long.valueOf(0L));
            }
            if (localUser.getUploadLimit() == null) {
                localUser.setUploadLimit(Long.valueOf(0L));
            }
            if (localUser.getQuotaLimit() == null) {
                localUser.setQuotaLimit(Long.valueOf(0L));
            }
            localUser.setUsed(Integer.valueOf(0));
            localUser.setQuotaLeft(true);
        } else {
            localUser2 = this.getUser(localUser.getId());
            localUser.setUserName(localUser2.getUserName());
            localUser.setUsed(localUser2.getUsed());
            if (localUser.getDownloadLimit() == null) {
                localUser.setDownloadLimit(Long.valueOf(0L));
            }
            if (localUser.getUploadLimit() == null) {
                localUser.setUploadLimit(Long.valueOf(0L));
            }
            if (localUser.getQuotaLimit() == null) {
                localUser.setQuotaLimit(Long.valueOf(0L));
            }
            if (!localUser2.getMacType().equals(localUser.getMacType())) {
                localUser.setUsed(Integer.valueOf(0));
            }
        }
        return this.saveUser(localUser);
    }

    @Override
    public OperationResponse deleteLocalUser(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("id", null);
        return this.delUser(string);
    }

    @Override
    public OperationResponse changeStatus(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("id", null);
        return this.changeStatus(string);
    }

    @Override
    public OperationResponse clearDynamicMac(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("id", null);
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return com.tp_link.eap.util.e.aZ;
        }
        return this.clearDynamicMac(string);
    }

    @Override
    public void downloadLocalUserExcel(HttpServletResponse response, ControlType controlType, JSONObject reqObj) throws Exception {
        String string = "Local_User_" + com.tp_link.eap.d.b.a() + "_";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm");
        string = string.concat(simpleDateFormat.format(new Date()).toString());
        List<LocalUser> list = this.getAll();
        List<Map<String, Object>> list2 = this.a(list);
        String[] stringArray = new String[]{"User Name", "PassWord", "Status", "Expiration Time", "Maximum Users", "MAC Address Binding Type", "MAC Address", "Name", "Telephone", "Downlimit Enable", "Download BandWidth Limit", "Uplimit Enable", "Upload BandWidth Limit", "Traffic Limit Enable", "Traffic Limit"};
        String[] stringArray2 = new String[]{"userName", "passWord", "status", "expirationTime", "maximumUsers", "macType", "macAddress", "name", "telephone", "downloadEnable", "downloadLimit", "uploadEnable", "uploadLimit", "quotaEnable", "quotaLimit"};
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            com.tp_link.eap.util.f.a.a(list2, (String[])stringArray2, (String[])stringArray).write((OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            this.a.warn(iOException.toString(), (Throwable)iOException);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        response.reset();
        response.setContentType("application/vnd.ms-excel;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + string + ".xls");
        ServletOutputStream servletOutputStream = response.getOutputStream();
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            int n2;
            bufferedInputStream = new BufferedInputStream(byteArrayInputStream);
            filterOutputStream = new BufferedOutputStream((OutputStream)servletOutputStream);
            byte[] byArray2 = new byte[2048];
            while (-1 != (n2 = bufferedInputStream.read(byArray2, 0, byArray2.length))) {
                ((BufferedOutputStream)filterOutputStream).write(byArray2, 0, n2);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
        }
    }

    @Override
    public OperationResponse downloadLocalUserExcel(String transferId, ControlType controlType, JSONObject reqObj, ChannelHandlerContext ctx) {
        String string = "Local_User_" + com.tp_link.eap.d.b.a() + "_";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm");
        string = string.concat(simpleDateFormat.format(new Date()).toString());
        List<LocalUser> list = this.getAll();
        List<Map<String, Object>> list2 = this.a(list);
        String[] stringArray = new String[]{"User Name", "PassWord", "Status", "Expiration Time", "Maximum Users", "MAC Address Binding Type", "MAC Address", "Name", "Telephone", "Downlimit Enable", "Download BandWidth Limit", "Uplimit Enable", "Upload BandWidth Limit", "Traffic Limit Enable", "Traffic Limit"};
        String[] stringArray2 = new String[]{"userName", "passWord", "status", "expirationTime", "maximumUsers", "macType", "macAddress", "name", "telephone", "downloadEnable", "downloadLimit", "uploadEnable", "uploadLimit", "quotaEnable", "quotaLimit"};
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            com.tp_link.eap.util.f.a.a(list2, (String[])stringArray2, (String[])stringArray).write((OutputStream)byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byte[] byArray2 = Base64.getEncoder().encode(byArray);
            ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])byArray2);
            DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, byteBuf);
            defaultFullHttpResponse.headers().set(HttpHeaders.Names.CONNECTION, (Object)HttpHeaders.Values.KEEP_ALIVE);
            defaultFullHttpResponse.headers().set((CharSequence)"X-Transfer-Id", (Object)transferId);
            defaultFullHttpResponse.headers().set((CharSequence)"Encode", (Object)"base64");
            defaultFullHttpResponse.headers().set((CharSequence)"Content-Disposition", (Object)("attachment;filename=" + string + ".xls"));
            defaultFullHttpResponse.headers().set(HttpHeaders.Names.CONTENT_LENGTH, (Object)byArray2.length);
            com.tp_link.eap.monitor.cloud.proxy.a.a.a(ctx, defaultFullHttpResponse);
            return com.tp_link.eap.util.e.bd;
        }
        catch (IOException iOException) {
            this.a.warn(iOException.toString(), (Throwable)iOException);
            return com.tp_link.eap.util.e.aY;
        }
    }

    @Override
    public void downloadLocalUserCSV(HttpServletResponse response, ControlType controlType, JSONObject reqObj) {
        List<LocalUser> list = this.getAll();
        List<Map<String, Object>> list2 = this.a(list);
        String string = null;
        String string2 = null;
        String[] stringArray = new String[]{"User Name", "PassWord", "Status", "Expiration Time", "Maximum Users", "MAC Address Binding Type", "MAC Address", "Name", "Telephone", "Downlimit Enable", "Download BandWidth Limit", "Uplimit Enable", "Upload BandWidth Limit", "Traffic Limit Enable", "Traffic Limit"};
        String[] stringArray2 = new String[]{"userName", "passWord", "status", "expirationTime", "maximumUsers", "macType", "macAddress", "name", "telephone", "downloadEnable", "downloadLimit", "uploadEnable", "uploadLimit", "quotaEnable", "quotaLimit"};
        string = "Local_User_" + com.tp_link.eap.d.b.a() + "_";
        string2 = com.tp_link.eap.util.b.a.a(list2, (String[])stringArray, (String[])stringArray2);
        try {
            com.tp_link.eap.util.b.a.a((String)string, (String)string2, (HttpServletResponse)response);
        }
        catch (IOException iOException) {
            this.a.warn(iOException.toString(), (Throwable)iOException);
        }
    }

    @Override
    public OperationResponse downloadLocalUserCSV(String transferId, ControlType controlType, JSONObject reqObj, ChannelHandlerContext ctx) {
        List<LocalUser> list = this.getAll();
        List<Map<String, Object>> list2 = this.a(list);
        String[] stringArray = new String[]{"User Name", "PassWord", "Status", "Expiration Time", "Maximum Users", "MAC Address Binding Type", "MAC Address", "Name", "Telephone", "Downlimit Enable", "Download BandWidth Limit", "Uplimit Enable", "Upload BandWidth Limit", "Traffic Limit Enable", "Traffic Limit"};
        String[] stringArray2 = new String[]{"userName", "passWord", "status", "expirationTime", "maximumUsers", "macType", "macAddress", "name", "telephone", "downloadEnable", "downloadLimit", "uploadEnable", "uploadLimit", "quotaEnable", "quotaLimit"};
        String string = "Local_User_" + com.tp_link.eap.d.b.a() + "_";
        String string2 = com.tp_link.eap.util.b.a.a(list2, (String[])stringArray, (String[])stringArray2);
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm");
            String string3 = string.concat(simpleDateFormat.format(new Date()).toString() + ".csv");
            byte[] byArray = Base64.getEncoder().encode(string2.getBytes("GBK"));
            ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])byArray);
            DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, byteBuf);
            defaultFullHttpResponse.headers().set(HttpHeaders.Names.CONNECTION, (Object)HttpHeaders.Values.KEEP_ALIVE);
            defaultFullHttpResponse.headers().set((CharSequence)"X-Transfer-Id", (Object)transferId);
            defaultFullHttpResponse.headers().set((CharSequence)"Encode", (Object)"base64");
            defaultFullHttpResponse.headers().set((CharSequence)"Content-Disposition", (Object)("attachment; filename=" + string3));
            defaultFullHttpResponse.headers().set(HttpHeaders.Names.CONTENT_LENGTH, (Object)byArray.length);
            com.tp_link.eap.monitor.cloud.proxy.a.a.a(ctx, defaultFullHttpResponse);
            return com.tp_link.eap.util.e.bd;
        }
        catch (IOException iOException) {
            this.a.warn(iOException.toString(), (Throwable)iOException);
            return com.tp_link.eap.util.e.aY;
        }
    }

    @Override
    public OperationResponse uploadLocalUserFile(HttpServletRequest request, HttpServletResponse response, ControlType controlType, JSONObject reqObj) throws Exception {
        MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)request;
        InputStream inputStream = null;
        List list = new ArrayList();
        MultipartFile multipartFile = multipartHttpServletRequest.getFile("file");
        if (multipartFile.isEmpty()) {
            return new OperationResponse(ResErrorCode.el);
        }
        inputStream = multipartFile.getInputStream();
        String string = multipartFile.getOriginalFilename();
        list = string.substring(string.lastIndexOf(".")).equals(".csv") ? com.tp_link.eap.util.b.a.a((InputStream)inputStream) : new com.tp_link.eap.util.f.a().a(inputStream, multipartFile.getOriginalFilename(), 15);
        inputStream.close();
        List<LocalUser> list2 = this.b(list);
        if (list2.size() < list.size()) {
            return new OperationResponse(ResErrorCode.em);
        }
        if (!CollectionUtils.isEmpty(list2)) {
            int n2 = 0;
            for (LocalUser localUser : list2) {
                if (localUser.getId() == null) continue;
                ++n2;
            }
            if ((long)(list2.size() - n2) + this.count() > 50000L) {
                HashMap hashMap = new HashMap();
                hashMap.put("data", "over");
                return new OperationResponse(ResErrorCode.en, (Object)hashMap);
            }
            this.b.save(list2);
        }
        return new OperationResponse(ResErrorCode.a, "Success", null);
    }

    @Override
    public OperationResponse uploadLocalUserFile(ControlType controlType, JSONObject reqData, String fileName, byte[] fileContent) {
        List list = new ArrayList();
        if (fileContent.length <= 0) {
            return new OperationResponse(ResErrorCode.el);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fileContent);
        try {
            list = fileName.substring(fileName.lastIndexOf(".")).equals(".csv") ? com.tp_link.eap.util.b.a.a((InputStream)byteArrayInputStream) : new com.tp_link.eap.util.f.a().a((InputStream)byteArrayInputStream, fileName, 15);
        }
        catch (Exception exception) {
            this.a.warn(exception.toString(), (Throwable)exception);
            return com.tp_link.eap.util.e.aZ;
        }
        List<LocalUser> list2 = this.b(list);
        if (list2.size() < list.size()) {
            return new OperationResponse(ResErrorCode.em);
        }
        if (!CollectionUtils.isEmpty(list2)) {
            int n2 = 0;
            for (LocalUser localUser : list2) {
                if (localUser.getId() == null) continue;
                ++n2;
            }
            if ((long)(list2.size() - n2) + this.count() > 50000L) {
                HashMap hashMap = new HashMap();
                hashMap.put("data", "over");
                return new OperationResponse(ResErrorCode.en, (Object)hashMap);
            }
            this.b.save(list2);
        }
        return new OperationResponse(ResErrorCode.a, "Success", null);
    }

    @Override
    public OperationResponse getLocalUser(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("id", null);
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return com.tp_link.eap.util.e.aZ;
        }
        LocalUser localUser = this.getUser(string);
        if (localUser == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        return new OperationResponse(ResErrorCode.a, (Object)localUser);
    }

    @Override
    public OperationResponse checkLocalUserOverLimit(ControlType controlType, JSONObject reqObj) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("data", this.count() >= 50000L);
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    private List<Map<String, Object>> a(List<LocalUser> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        LocalUser localUser = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            localUser = list.get(i2);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("userName", localUser.getUserName());
            hashMap.put("passWord", localUser.getPassword());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date date = new Date();
            try {
                Date date2 = simpleDateFormat.parse(localUser.getExpirationTime());
                if (date.getTime() > date2.getTime()) {
                    hashMap.put("status", "Timeout");
                } else if (localUser.getStatus()) {
                    hashMap.put("status", "Enable");
                } else {
                    hashMap.put("status", "Disable");
                }
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
            hashMap.put("expirationTime", localUser.getExpirationTime());
            if (localUser.getMacType() == 0) {
                hashMap.put("macType", "No Binding");
            } else if (localUser.getMacType() == 1) {
                hashMap.put("macType", "Static Binding");
            } else {
                hashMap.put("macType", "Dynamic Binding");
            }
            hashMap.put("macAddress", localUser.getMacAddress());
            hashMap.put("maximumUsers", localUser.getMaximumUsers());
            hashMap.put("name", localUser.getName());
            hashMap.put("telephone", localUser.getTelephone());
            if (localUser.getDownloadEnable()) {
                hashMap.put("downloadEnable", "Enable");
            } else {
                hashMap.put("downloadEnable", "Disable");
            }
            if (localUser.getDownloadLimit() > 0L) {
                hashMap.put("downloadLimit", localUser.getDownloadLimit());
            } else {
                hashMap.put("downloadLimit", "");
            }
            if (localUser.getUploadEnable()) {
                hashMap.put("uploadEnable", "Enable");
            } else {
                hashMap.put("uploadEnable", "Disable");
            }
            if (localUser.getUploadLimit() > 0L) {
                hashMap.put("uploadLimit", localUser.getUploadLimit());
            } else {
                hashMap.put("uploadLimit", "");
            }
            if (localUser.getQuotaEnable()) {
                hashMap.put("quotaEnable", "Enable");
            } else {
                hashMap.put("quotaEnable", "Disable");
            }
            if (localUser.getQuotaLimit() > 0L) {
                hashMap.put("quotaLimit", localUser.getQuotaLimit());
            } else {
                hashMap.put("quotaLimit", "");
            }
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    private List<LocalUser> b(List<String[]> list) {
        if (list == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        String string = com.tp_link.eap.d.b.a();
        ArrayList<LocalUser> arrayList = new ArrayList<LocalUser>();
        String string2 = "^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$";
        Pattern pattern2 = Pattern.compile(string2);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy/MM/dd");
        try {
            Date date = simpleDateFormat.parse("1970-01-01");
            Date date2 = simpleDateFormat.parse("2060-12-31");
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Date date3;
                String[] stringArray = list.get(i2);
                if (stringArray.length != 15) continue;
                if (stringArray[0] == null || stringArray[1] == null) break;
                LocalUser localUser = new LocalUser();
                if (stringArray[0].trim().equals("")) break;
                localUser.setUserName(String.valueOf(stringArray[0].trim()));
                if (stringArray[1].trim().equals("")) break;
                localUser.setPassword(String.valueOf(stringArray[1].trim()));
                if (stringArray[2] == null || stringArray[2].trim().equals("") || stringArray[2].trim().toLowerCase(Locale.ROOT).equals("enable")) {
                    localUser.setStatus(true);
                } else {
                    if (!stringArray[2].trim().toLowerCase(Locale.ROOT).equals("disable") && !stringArray[2].trim().equals("Timeout")) break;
                    localUser.setStatus(false);
                }
                SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat("yyyy");
                Date date4 = new Date();
                String string3 = simpleDateFormat3.format(date4) + "-12-31";
                if (stringArray[3] == null || stringArray[3].trim().equals("")) {
                    localUser.setExpirationTime(string3);
                } else {
                    if (!pattern2.matcher(stringArray[3].trim()).matches()) break;
                    date3 = simpleDateFormat.parse(stringArray[3].trim().replace("/", "-"));
                    if (date3.getTime() <= date2.getTime() && date3.getTime() >= date.getTime()) {
                        localUser.setExpirationTime(simpleDateFormat.format(date3));
                    } else {
                        localUser.setExpirationTime(string3);
                    }
                }
                if (stringArray[4] == null || stringArray[4].trim().equals("")) {
                    localUser.setMaximumUsers(Integer.valueOf(1));
                } else {
                    if (!pattern.matcher(stringArray[4].trim()).matches()) break;
                    localUser.setMaximumUsers(Integer.valueOf(stringArray[4].trim()));
                    if (localUser.getMaximumUsers() == 0) {
                        localUser.setMaximumUsers(Integer.valueOf(1));
                    }
                }
                if (stringArray[5] == null || stringArray[5].trim().equals("")) {
                    localUser.setMacType(Integer.valueOf(0));
                } else if (stringArray[5].toLowerCase(Locale.ROOT).equals("no binding")) {
                    localUser.setMacType(Integer.valueOf(0));
                } else if (stringArray[5].toLowerCase(Locale.ROOT).equals("static binding")) {
                    localUser.setMacType(Integer.valueOf(1));
                } else if (stringArray[5].toLowerCase(Locale.ROOT).equals("dynamic binding")) {
                    localUser.setMacType(Integer.valueOf(2));
                } else {
                    localUser.setMacType(Integer.valueOf(0));
                }
                if (stringArray[6] == null || stringArray[6].trim().equals("")) {
                    localUser.setMacAddress("");
                } else {
                    if (!com.tp_link.eap.util.p.c.d((String)l.c((String)stringArray[6].trim()))) break;
                    localUser.setMacAddress(l.c((String)stringArray[6].trim()));
                }
                if (localUser.getMacType() == 0) {
                    localUser.setMacAddress("");
                }
                if (stringArray[7] == null || stringArray[7].trim().equals("")) {
                    localUser.setName("");
                } else {
                    localUser.setName(String.valueOf(stringArray[7]));
                }
                if (stringArray[8] == null || stringArray[8].trim().equals("")) {
                    localUser.setTelephone("");
                } else {
                    localUser.setTelephone(String.valueOf(stringArray[8]));
                }
                if (stringArray[9] == null || stringArray[9].trim().equals("") || stringArray[9].trim().toLowerCase(Locale.ROOT).equals("disable")) {
                    localUser.setDownloadEnable(false);
                } else {
                    if (!stringArray[9].trim().toLowerCase(Locale.ROOT).equals("enable")) break;
                    localUser.setDownloadEnable(true);
                }
                if (!localUser.getDownloadEnable()) {
                    localUser.setDownloadLimit(Long.valueOf(0L));
                } else {
                    if (stringArray[10] == null || stringArray[10].trim().equals("") || !pattern.matcher(stringArray[10].trim()).matches()) break;
                    long l2 = Long.valueOf(stringArray[10].trim());
                    if (l2 < 0L) {
                        l2 = 0L;
                    } else if (l2 > 10240000L) {
                        l2 = 10240000L;
                    }
                    localUser.setDownloadLimit(Long.valueOf(l2));
                }
                if (stringArray[11] == null || stringArray[11].trim().equals("") || stringArray[11].trim().toLowerCase(Locale.ROOT).equals("disable")) {
                    localUser.setUploadEnable(false);
                } else {
                    if (!stringArray[11].trim().toLowerCase(Locale.ROOT).equals("enable")) break;
                    localUser.setUploadEnable(true);
                }
                if (!localUser.getUploadEnable()) {
                    localUser.setUploadLimit(Long.valueOf(0L));
                } else {
                    if (stringArray[12] == null || stringArray[12].trim().equals("") || !pattern.matcher(stringArray[12].trim()).matches()) break;
                    long l3 = Long.valueOf(stringArray[12].trim());
                    if (l3 < 0L) {
                        l3 = 0L;
                    } else if (l3 > 10240000L) {
                        l3 = 10240000L;
                    }
                    localUser.setUploadLimit(Long.valueOf(l3));
                }
                if (stringArray[13] == null || stringArray[13].trim().equals("") || stringArray[13].trim().toLowerCase(Locale.ROOT).equals("disable")) {
                    localUser.setQuotaEnable(false);
                } else {
                    if (!stringArray[13].trim().toLowerCase(Locale.ROOT).equals("enable")) break;
                    localUser.setQuotaEnable(true);
                }
                if (!localUser.getQuotaEnable()) {
                    localUser.setQuotaLimit(Long.valueOf(0L));
                } else {
                    if (stringArray[14] == null || stringArray[14].trim().equals("") || !pattern.matcher(stringArray[14].trim()).matches()) break;
                    long l4 = Long.valueOf(stringArray[14].trim());
                    if (l4 < 0L) {
                        l4 = 0L;
                    } else if (l4 > 0x100000L) {
                        l4 = 0x100000L;
                    }
                    localUser.setQuotaLimit(Long.valueOf(l4));
                }
                localUser.setSite(string);
                date3 = this.getUserByUserNameAndSite(stringArray[0], string);
                if (date3 != null) {
                    localUser.setId(date3.getId());
                }
                localUser.setUsed(Integer.valueOf(0));
                localUser.setQuotaLeft(true);
                arrayList.add(localUser);
            }
        }
        catch (ParseException parseException) {
            this.a.warn(parseException.toString(), (Throwable)parseException);
        }
        return arrayList;
    }
}

